const { app, BrowserWindow } = require('electron')

app.commandLine.appendSwitch('ignore-certificate-errors', 'true');
app.commandLine.appendSwitch('allow-insecure-localhost', 'true');
app.commandLine.appendSwitch('ignore-gpu-blocklist', 'true');

function createWindow () {
  const win = new BrowserWindow({
    width: 1024,
    height: 768,
    webPreferences: {
      nodeIntegration: true,
      allowRunningInsecureContent: true,
      allowDisplayingInsecureContent: true,
      webSecurity: false
    }
  })

//*****START ALLOW ZOOOM *********/
// If reduced below Minimum value 
// Error - 'zoomFactor' must be a double greater than 0.0 
win.webContents.setZoomFactor(1.0); 
  
// Upper Limit is working of 500 % 
win.webContents 
    .setVisualZoomLevelLimits(1, 5) 
    .then(console.log("Zoom Levels Have been Set between 100% and 500%")) 
    .catch((err) => console.log(err)); 

    win.webContents.on("zoom-changed", (event, zoomDirection) => { 
      console.log(zoomDirection); 
      var currentZoom = win.webContents.getZoomFactor(); 
      if (zoomDirection === "in") {          
          win.webContents.zoomFactor = currentZoom + 0.2; 
      } 
      if (zoomDirection === "out") { 
          win.webContents.zoomFactor = currentZoom - 0.2; 
      } 
  });

  //*****END ALLOW ZOOOM *********/

  win.removeMenu() 
  win.loadURL('https://rmjs.rmadvanced.com')
  
}



app.whenReady().then(createWindow)

app.on('window-all-closed', () => {
  if (process.platform !== 'darwin') {
    app.quit()
  }
})

app.on('activate', () => {
  if (BrowserWindow.getAllWindows().length === 0) {
    createWindow()
  }
})